<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\ExtSoapEngine\Configuration\TypeConverter;

/**
 * Converts between PHP \DateTime and SOAP dateTime objects
 */
final class DateTimeTypeConverter implements TypeConverterInterface
{
    public function getTypeNamespace(): string
    {
        return 'http://www.w3.org/2001/XMLSchema';
    }

    public function getTypeName(): string
    {
        return 'dateTime';
    }

    /**
     * @param non-empty-string $xml
     */
    public function convertXmlToPhp(string $xml): ?\DateTimeImmutable
    {
        $doc = new \DOMDocument();
        $doc->loadXML($xml);

        if ('' === $doc->textContent) {
            return null;
        }

        return (new \DateTimeImmutable($doc->textContent))
            ->setTimezone(new \DateTimeZone(date_default_timezone_get()));
    }

    public function convertPhpToXml($php): string
    {
        if (!$php instanceof \DateTimeInterface) {
            return '';
        }

        return sprintf('<%1$s>%2$s</%1$s>', $this->getTypeName(), $php->format(\DateTimeInterface::RFC3339));
    }
}
