<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\Engine\Metadata\Model;

use Gls\GlsPoland\Soap\Engine\Metadata\Collection\PropertyCollection;

final class Type
{
    /**
     * @var XsdType
     */
    private $xsdType;
    /**
     * @var PropertyCollection
     */
    private $properties;

    public function __construct(XsdType $xsdType, PropertyCollection $properties)
    {
        $this->xsdType = $xsdType;
        $this->properties = $properties;
    }

    public function getName(): string
    {
        return $this->xsdType->getName();
    }

    public function getXsdType(): XsdType
    {
        return $this->xsdType;
    }

    public function getProperties(): PropertyCollection
    {
        return $this->properties;
    }
}
