<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

use Gls\GlsPoland\Carrier\CarrierType;
use Gls\GlsPoland\Carrier\DTO\AdditionalServices;
use Symfony\Component\Validator\Constraints as Assert;

class CreateCourierCarrierCommand extends AbstractCreateCarrierCommand
{
    private $type;

    /**
     * @var AdditionalServices
     *
     * @Assert\NotNull()
     */
    private $services;

    /**
     * @param string[] $countryIsoCodes
     */
    public function __construct(?string $name = null, array $countryIsoCodes = [], ?AdditionalServices $services = null)
    {
        $this->type = CarrierType::from(CarrierType::COURIER);

        parent::__construct($name, ...$countryIsoCodes);

        $this->services = $services ?? new AdditionalServices();
    }

    public function getType(): CarrierType
    {
        return $this->type;
    }

    public function getServices(): AdditionalServices
    {
        return $this->services;
    }

    public function setServices(AdditionalServices $services): self
    {
        $this->services = $services;

        return $this;
    }

    public function isCashOnDelivery(): bool
    {
        return $this->services->isCashOnDelivery();
    }
}
