<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Configuration;

use Gls\GlsPoland\Configuration\ConfigurationInterface;

final class ShopConfigurationRepository
{
    public const DEFAULT_COUNTRY_ID = 'PS_COUNTRY_DEFAULT';
    public const DEFAULT_CURRENCY_ID = 'PS_CURRENCY_DEFAULT';

    private $configuration;

    public function __construct(ConfigurationInterface $configuration)
    {
        $this->configuration = $configuration;
    }

    public function getDefaultCountryId(): int
    {
        return (int) $this->configuration->get(self::DEFAULT_COUNTRY_ID);
    }

    public function getDefaultCurrencyId(): int
    {
        return (int) $this->configuration->get(self::DEFAULT_CURRENCY_ID);
    }
}
