<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Carrier;

final class CarrierType implements \Stringable
{
    public const COURIER = 'courier';
    public const SHOP_DELIVERY = 'sds';

    private const TYPES = [
        self::COURIER,
        self::SHOP_DELIVERY,
    ];

    private $value;

    private function __construct(string $type)
    {
        $this->value = $type;
    }

    public static function from(string $type): self
    {
        if (!in_array($type, self::TYPES, true)) {
            throw new \InvalidArgumentException(sprintf('Unrecognized carrier type "%s".', $type));
        }

        return new self($type);
    }

    public static function tryFrom($value): ?self
    {
        if (!in_array($value, self::TYPES, true)) {
            return null;
        }

        return new self($value);
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function __toString(): string
    {
        return $this->value;
    }
}
