<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

use Gls\GlsPoland\AdePlus\Authorization\AuthorizedRequest;

final class GetConsignment extends AuthorizedRequest
{
    /**
     * @var int
     */
    private $id;

    public function __construct(int $id)
    {
        $this->id = $id;
    }

    public function jsonSerialize(): array
    {
        return [
            'id' => $this->id,
        ];
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function withId(int $id): GetConsignment
    {
        $new = clone $this;
        $new->id = $id;

        return $new;
    }
}
