<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Authorization;

use Gls\GlsPoland\Soap\Client\Type\RequestInterface;

final class Logout implements RequestInterface
{
    /**
     * @var string
     */
    private $session;

    public function __construct(string $session)
    {
        $this->session = $session;
    }

    public function getSession(): string
    {
        return $this->session;
    }

    public function withSession(string $session): self
    {
        $new = clone $this;
        $new->session = $session;

        return $new;
    }

    public function __debugInfo(): array
    {
        return [];
    }
}
