<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Authorization;

use Gls\GlsPoland\Soap\Client\Type\RequestInterface;

final class LoginIntegrator implements RequestInterface, \JsonSerializable
{
    private $user_name;
    private $user_password;
    private $integrator;

    public function __construct(string $username, string $password, string $integratorId)
    {
        $this->user_name = $username;
        $this->user_password = $password;
        $this->integrator = $integratorId;
    }

    public function __debugInfo(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        return [
            'user_name' => $this->user_name,
            'integrator' => $this->integrator,
        ];
    }

    public function getUsername(): string
    {
        return $this->user_name;
    }

    public function withUsername(string $username): LoginIntegrator
    {
        $new = clone $this;
        $new->user_name = $username;

        return $new;
    }

    public function getPassword(): string
    {
        return $this->user_password;
    }

    public function withPassword(string $password): LoginIntegrator
    {
        $new = clone $this;
        $new->user_password = $password;

        return $new;
    }

    public function getIntegratorId(): string
    {
        return $this->integrator;
    }

    public function withIntegratorId(string $integratorId): LoginIntegrator
    {
        $new = clone $this;
        $new->integrator = $integratorId;

        return $new;
    }
}
